from langchain.chat_models import ChatOpenAI
from langchain.prompts.chat import (
    ChatPromptTemplate,
    HumanMessagePromptTemplate,
)
from dotenv import load_dotenv
import os

# load the environment variables from the .env file
load_dotenv()

# get the value of the OPENAI_API_KEY environment variable
OPENAI_API_KEY = os.environ.get("OPENAI_API_KEY")

def natural_language_task_function(instructions):
    """
    Generates a response to a given instruction using OpenAI's GPT-3.5-Turbo model.
    Args:
      instructions (str): The instruction to generate a response to.
    Returns:
      str: The response generated by the GPT-3.5-Turbo model.
    Examples:
      >>> natural_language_task_function("What is the weather like today?")
      "It's sunny and warm today."
    """
    chat = ChatOpenAI(temperature  = 0, model= 'gpt-3.5-turbo', openai_api_key=OPENAI_API_KEY)
    human_template = "{instructions}"
    human_message_prompt = HumanMessagePromptTemplate.from_template(human_template)
    chat_prompt = ChatPromptTemplate.from_messages([human_message_prompt])
    response = chat(chat_prompt.format_prompt(instructions=instructions).to_messages()).content
    return response